#!/bin/bash
gmt begin acapulco7.51_dcal pdf,ps
proj=-JM16.0c+
reg=-R-102.5/-96.8/14.5/19.2
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration acapulco7.51'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
  -100.267    17.048
  -100.092    16.981
>
  -100.267    17.048
  -100.092    16.981
>
   -99.858    16.869
  -100.092    16.981
>
   -99.858    16.869
  -100.092    16.981
>
  -100.267    17.048
  -100.507    17.255
>
  -100.267    17.048
  -100.507    17.255
>
   -99.858    16.869
  -100.507    17.255
>
   -99.858    16.869
  -100.507    17.255
>
  -101.465    17.607
  -100.507    17.255
>
  -101.465    17.607
  -100.507    17.255
>
  -100.267    17.048
  -100.320    17.209
>
  -100.267    17.048
  -100.320    17.209
>
   -99.858    16.869
  -100.320    17.209
>
   -99.620    17.926
  -100.320    17.209
>
   -99.620    17.926
  -100.320    17.209
>
  -100.267    17.048
  -100.302    17.203
>
  -100.267    17.048
  -100.302    17.203
>
   -99.858    16.869
  -100.302    17.203
>
   -99.620    17.926
  -100.302    17.203
>
   -99.620    17.926
  -100.302    17.203
>
  -100.267    17.048
  -100.113    16.966
>
  -100.267    17.048
  -100.113    16.966
>
  -100.267    17.048
  -100.300    16.896
>
  -100.267    17.048
  -100.300    16.896
>
   -99.887    16.874
  -100.300    16.896
>
   -99.887    16.874
  -100.300    16.896
>
   -99.858    16.869
  -100.300    16.896
>
  -100.267    17.048
   -99.570    16.909
>
  -100.267    17.048
   -99.570    16.909
>
   -99.858    16.869
   -99.659    17.094
>
   -99.858    16.869
   -99.659    17.094
>
  -100.267    17.048
   -99.659    17.094
>
  -100.267    17.048
   -99.659    17.094
>
   -99.887    16.874
   -99.617    16.781
>
   -99.887    16.874
   -99.617    16.781
>
  -100.267    17.048
   -99.617    16.781
>
  -100.267    17.048
   -99.617    16.781
>
   -98.127    16.392
   -98.801    16.723
>
   -98.566    17.563
   -98.801    16.723
>
   -98.566    17.563
   -98.801    16.723
>
   -98.566    17.563
   -98.801    16.723
>
   -99.887    16.874
   -99.603    16.909
>
  -100.267    17.048
   -99.603    16.909
>
  -100.267    17.048
   -99.603    16.909
>
  -100.267    17.048
  -100.097    17.009
>
   -99.887    16.874
  -100.097    17.009
>
   -99.887    16.874
  -100.097    17.009
>
   -99.887    16.874
   -99.340    16.591
>
   -99.887    16.874
   -99.340    16.591
>
  -100.267    17.048
   -99.340    16.591
>
  -100.267    17.048
   -99.340    16.591
>
   -99.887    16.874
   -99.517    16.819
>
   -99.887    16.874
   -99.517    16.819
>
  -100.267    17.048
   -99.517    16.819
>
   -99.887    16.874
   -99.649    16.796
>
   -99.887    16.874
   -99.649    16.796
>
  -100.267    17.048
   -99.649    16.796
>
  -100.267    17.048
   -99.649    16.796
>
   -99.887    16.874
  -100.101    16.810
>
   -99.887    16.874
  -100.101    16.810
>
  -100.267    17.048
  -100.101    16.810
>
  -100.267    17.048
  -100.101    16.810
>
   -99.887    16.874
   -99.871    17.167
>
   -99.887    16.874
   -99.871    17.167
>
   -99.887    16.874
   -99.871    17.167
>
  -100.267    17.048
   -99.871    17.167
>
  -100.267    17.048
   -99.871    17.167
>
  -100.267    17.048
   -99.871    17.167
>
   -99.131    16.736
   -99.871    17.167
>
   -99.131    16.736
   -99.871    17.167
>
   -99.620    17.926
   -99.871    17.167
>
   -99.620    17.926
   -99.871    17.167
>
   -99.131    16.736
   -99.785    16.742
>
   -99.131    16.736
   -99.785    16.742
>
  -100.267    17.048
   -99.785    16.742
>
  -100.267    17.048
   -99.785    16.742
>
   -99.651    17.021
   -99.730    17.064
>
   -99.651    17.021
   -99.730    17.064
>
   -99.651    17.021
   -99.730    17.064
>
  -100.267    17.048
   -99.730    17.064
>
  -100.267    17.048
   -99.730    17.064
>
   -99.620    17.926
   -99.730    17.064
>
   -99.620    17.926
   -99.730    17.064
>
   -98.634    17.234
   -98.928    16.939
>
   -98.634    17.234
   -98.928    16.939
>
   -99.651    17.021
   -98.928    16.939
>
   -99.651    17.021
   -98.928    16.939
>
   -98.566    17.563
   -98.928    16.939
>
   -98.566    17.563
   -98.928    16.939
>
   -98.566    17.563
   -98.928    16.939
>
   -98.127    16.392
   -98.928    16.939
>
   -99.887    16.874
   -98.928    16.939
>
   -99.887    16.874
   -98.928    16.939
>
   -98.560    17.798
   -98.928    16.939
>
   -98.560    17.798
   -98.928    16.939
>
   -98.634    17.234
   -98.750    16.951
>
   -98.634    17.234
   -98.750    16.951
>
   -99.131    16.736
   -98.750    16.951
>
   -99.131    16.736
   -98.750    16.951
>
   -98.566    17.563
   -98.750    16.951
>
   -98.566    17.563
   -98.750    16.951
>
   -98.127    16.392
   -98.750    16.951
>
   -98.560    17.798
   -98.750    16.951
>
   -98.560    17.798
   -98.750    16.951
>
   -99.651    17.021
   -98.750    16.951
>
   -99.651    17.021
   -98.750    16.951
>
   -97.768    17.253
   -98.750    16.951
>
   -97.768    17.253
   -98.750    16.951
>
   -99.651    17.021
   -99.566    17.082
>
   -99.651    17.021
   -99.566    17.082
>
   -99.887    16.874
   -99.566    17.082
>
   -99.887    16.874
   -99.566    17.082
>
   -99.131    16.736
   -99.566    17.082
>
   -99.131    16.736
   -99.566    17.082
>
  -100.267    17.048
   -99.566    17.082
>
  -100.267    17.048
   -99.566    17.082
>
   -99.620    17.926
   -99.566    17.082
>
   -99.620    17.926
   -99.566    17.082
>
   -98.634    17.234
   -99.566    17.082
>
   -98.634    17.234
   -99.566    17.082
>
   -99.819    16.914
  -100.021    17.133
>
   -99.819    16.914
  -100.021    17.133
>
   -99.887    16.874
  -100.021    17.133
>
   -99.887    16.874
  -100.021    17.133
>
   -99.651    17.021
  -100.021    17.133
>
   -99.651    17.021
  -100.021    17.133
>
  -100.267    17.048
  -100.021    17.133
>
  -100.267    17.048
  -100.021    17.133
>
  -100.432    17.213
  -100.021    17.133
>
  -100.432    17.213
  -100.021    17.133
>
   -99.620    17.926
  -100.021    17.133
>
   -99.131    16.736
  -100.021    17.133
>
   -99.131    16.736
  -100.021    17.133
>
   -99.131    16.736
   -99.437    16.709
>
   -99.131    16.736
   -99.437    16.709
>
   -99.651    17.021
   -99.437    16.709
>
   -99.651    17.021
   -99.437    16.709
>
   -99.819    16.914
   -99.437    16.709
>
   -99.887    16.874
   -99.437    16.709
>
  -100.267    17.048
   -99.437    16.709
>
   -98.634    17.234
   -99.437    16.709
>
   -98.634    17.234
   -99.437    16.709
>
  -100.267    17.048
  -100.219    17.213
>
  -100.267    17.048
  -100.219    17.213
>
  -100.432    17.213
  -100.219    17.213
>
  -100.432    17.213
  -100.219    17.213
>
   -99.887    16.874
  -100.219    17.213
>
   -99.887    16.874
  -100.219    17.213
>
   -99.819    16.914
  -100.219    17.213
>
   -99.819    16.914
  -100.219    17.213
>
   -99.651    17.021
  -100.219    17.213
>
   -99.651    17.021
  -100.219    17.213
>
   -99.620    17.926
  -100.219    17.213
>
   -99.620    17.926
  -100.219    17.213
>
  -100.267    17.048
   -99.771    17.009
>
  -100.267    17.048
   -99.771    17.009
>
  -100.432    17.213
   -99.771    17.009
>
  -100.432    17.213
   -99.771    17.009
>
   -99.620    17.926
   -99.771    17.009
>
   -99.887    16.874
   -99.715    16.779
>
   -99.887    16.874
   -99.715    16.779
>
   -99.819    16.914
   -99.715    16.779
>
   -99.819    16.914
   -99.715    16.779
>
   -99.651    17.021
   -99.715    16.779
>
   -99.651    17.021
   -99.715    16.779
>
  -100.267    17.048
   -99.715    16.779
>
  -100.432    17.213
   -99.715    16.779
>
  -100.432    17.213
   -99.715    16.779
>
   -98.634    17.234
   -99.032    16.446
>
   -98.634    17.234
   -99.032    16.446
>
   -99.651    17.021
   -99.032    16.446
>
   -99.651    17.021
   -99.032    16.446
>
  -100.432    17.213
  -100.447    17.323
>
  -100.432    17.213
  -100.447    17.323
>
  -100.267    17.048
  -100.447    17.323
>
  -100.267    17.048
  -100.447    17.323
>
   -99.887    16.874
  -100.447    17.323
>
   -99.887    16.874
  -100.447    17.323
>
   -99.819    16.914
  -100.447    17.323
>
   -99.819    16.914
  -100.447    17.323
>
  -101.263    17.535
  -100.447    17.323
>
  -101.263    17.535
  -100.447    17.323
>
   -99.651    17.021
  -100.447    17.323
>
   -99.651    17.021
  -100.447    17.323
>
  -100.347    18.281
  -100.447    17.323
>
  -100.347    18.281
  -100.447    17.323
>
   -99.620    17.926
  -100.447    17.323
>
   -99.620    17.926
  -100.447    17.323
>
   -99.819    16.914
   -99.655    17.151
>
   -99.819    16.914
   -99.655    17.151
>
   -99.887    16.874
   -99.655    17.151
>
   -99.887    16.874
   -99.655    17.151
>
  -100.267    17.048
   -99.655    17.151
>
  -100.267    17.048
   -99.655    17.151
>
   -99.131    16.736
   -99.655    17.151
>
   -99.131    16.736
   -99.655    17.151
>
  -100.432    17.213
   -99.655    17.151
>
  -100.432    17.213
   -99.655    17.151
>
   -99.620    17.926
   -99.655    17.151
>
   -99.620    17.926
   -99.655    17.151
>
   -98.634    17.234
   -99.655    17.151
>
   -98.634    17.234
   -99.655    17.151
>
   -99.819    16.914
   -99.468    16.659
>
   -99.819    16.914
   -99.468    16.659
>
   -99.887    16.874
   -99.468    16.659
>
  -100.267    17.048
   -99.468    16.659
>
  -100.267    17.048
  -100.075    17.188
>
  -100.267    17.048
  -100.075    17.188
>
  -100.432    17.213
  -100.075    17.188
>
  -100.432    17.213
  -100.075    17.188
>
   -99.887    16.874
  -100.075    17.188
>
   -99.887    16.874
  -100.075    17.188
>
   -99.819    16.914
  -100.075    17.188
>
   -99.819    16.914
  -100.075    17.188
>
   -99.651    17.021
  -100.075    17.188
>
   -99.651    17.021
  -100.075    17.188
>
   -99.620    17.926
  -100.075    17.188
>
   -99.620    17.926
  -100.075    17.188
>
   -99.651    17.021
   -99.677    17.162
>
   -99.651    17.021
   -99.677    17.162
>
   -99.819    16.914
   -99.677    17.162
>
   -99.819    16.914
   -99.677    17.162
>
   -99.887    16.874
   -99.677    17.162
>
   -99.887    16.874
   -99.677    17.162
>
  -100.267    17.048
   -99.677    17.162
>
  -100.267    17.048
   -99.677    17.162
>
  -100.432    17.213
   -99.677    17.162
>
  -100.432    17.213
   -99.677    17.162
>
   -99.620    17.926
   -99.677    17.162
>
   -99.620    17.926
   -99.677    17.162
>
   -98.634    17.234
   -99.677    17.162
>
   -98.634    17.234
   -99.677    17.162
>
  -100.267    17.048
  -100.423    16.877
>
  -100.267    17.048
  -100.423    16.877
>
  -100.432    17.213
  -100.423    16.877
>
  -100.432    17.213
  -100.423    16.877
>
   -99.887    16.874
  -100.423    16.877
>
   -99.819    16.914
  -100.423    16.877
>
   -99.651    17.021
  -100.423    16.877
>
   -99.651    17.021
  -100.423    16.877
>
   -99.887    16.874
   -99.881    16.892
>
   -99.887    16.874
   -99.881    16.892
>
   -99.651    17.021
   -99.881    16.892
>
   -99.651    17.021
   -99.881    16.892
>
  -100.267    17.048
   -99.881    16.892
>
  -100.432    17.213
   -99.881    16.892
>
  -100.432    17.213
   -99.881    16.892
>
   -99.131    16.736
   -99.881    16.892
>
   -99.131    16.736
   -99.881    16.892
>
   -99.651    17.021
   -99.682    17.058
>
   -99.651    17.021
   -99.682    17.058
>
   -99.887    16.874
   -99.682    17.058
>
   -99.887    16.874
   -99.682    17.058
>
   -99.131    16.736
   -99.682    17.058
>
   -99.131    16.736
   -99.682    17.058
>
  -100.267    17.048
   -99.682    17.058
>
  -100.267    17.048
   -99.682    17.058
>
  -100.432    17.213
   -99.682    17.058
>
  -100.432    17.213
   -99.682    17.058
>
   -99.620    17.926
   -99.682    17.058
>
   -99.620    17.926
   -99.682    17.058
>
   -99.131    16.736
   -99.024    16.932
>
   -99.131    16.736
   -99.024    16.932
>
   -98.634    17.234
   -99.024    16.932
>
   -99.651    17.021
   -99.024    16.932
>
   -99.651    17.021
   -99.024    16.932
>
   -98.566    17.563
   -99.024    16.932
>
   -98.566    17.563
   -99.024    16.932
>
   -99.887    16.874
   -99.024    16.932
>
   -99.887    16.874
   -99.024    16.932
>
   -98.560    17.798
   -99.024    16.932
>
   -99.651    17.021
   -99.610    17.167
>
   -99.887    16.874
   -99.610    17.167
>
   -99.887    16.874
   -99.610    17.167
>
   -99.620    17.926
   -99.610    17.167
>
  -100.267    17.048
   -99.610    17.167
>
  -100.267    17.048
   -99.610    17.167
>
  -100.432    17.213
   -99.610    17.167
>
  -100.432    17.213
   -99.610    17.167
>
   -98.634    17.234
   -99.610    17.167
>
   -98.634    17.234
   -99.610    17.167
>
  -100.432    17.213
  -100.417    17.302
>
  -100.432    17.213
  -100.417    17.302
>
  -100.267    17.048
  -100.417    17.302
>
  -100.267    17.048
  -100.417    17.302
>
   -99.887    16.874
  -100.417    17.302
>
   -99.887    16.874
  -100.417    17.302
>
   -99.651    17.021
  -100.417    17.302
>
   -99.651    17.021
  -100.417    17.302
>
  -101.263    17.535
  -100.417    17.302
>
  -101.263    17.535
  -100.417    17.302
>
  -100.347    18.281
  -100.417    17.302
>
  -100.347    18.281
  -100.417    17.302
>
   -99.620    17.926
  -100.417    17.302
>
   -99.131    16.736
   -99.042    17.100
>
   -99.131    16.736
   -99.042    17.100
>
   -98.634    17.234
   -99.042    17.100
>
   -98.634    17.234
   -99.042    17.100
>
   -99.651    17.021
   -99.042    17.100
>
   -99.651    17.021
   -99.042    17.100
>
   -98.566    17.563
   -99.042    17.100
>
   -98.566    17.563
   -99.042    17.100
>
   -98.560    17.798
   -99.042    17.100
>
   -98.560    17.798
   -99.042    17.100
>
   -99.887    16.874
   -99.042    17.100
>
   -99.620    17.926
   -99.042    17.100
>
   -99.620    17.926
   -99.042    17.100
>
  -100.267    17.048
  -100.026    17.165
>
  -100.267    17.048
  -100.026    17.165
>
   -99.887    16.874
  -100.026    17.165
>
   -99.887    16.874
  -100.026    17.165
>
   -99.651    17.021
  -100.026    17.165
>
   -99.651    17.021
  -100.026    17.165
>
  -100.432    17.213
  -100.026    17.165
>
  -100.432    17.213
  -100.026    17.165
>
   -99.620    17.926
  -100.026    17.165
>
   -99.620    17.926
  -100.026    17.165
>
   -99.131    16.736
  -100.026    17.165
>
   -99.131    16.736
  -100.026    17.165
>
   -99.819    16.914
   -99.926    17.099
>
   -99.819    16.914
   -99.926    17.099
>
   -99.887    16.874
   -99.926    17.099
>
   -99.887    16.874
   -99.926    17.099
>
   -99.651    17.021
   -99.926    17.099
>
   -99.651    17.021
   -99.926    17.099
>
  -100.267    17.048
   -99.926    17.099
>
  -100.267    17.048
   -99.926    17.099
>
  -100.432    17.213
   -99.926    17.099
>
  -100.432    17.213
   -99.926    17.099
>
   -99.131    16.736
   -99.926    17.099
>
   -99.620    17.926
   -99.926    17.099
>
   -99.620    17.926
   -99.926    17.099
>
   -99.887    16.874
   -99.788    16.769
>
   -99.651    17.021
   -99.788    16.769
>
   -99.651    17.021
   -99.788    16.769
>
  -100.267    17.048
   -99.788    16.769
>
  -100.267    17.048
   -99.788    16.769
>
   -99.131    16.736
   -99.788    16.769
>
   -99.131    16.736
   -99.788    16.769
>
  -100.432    17.213
   -99.788    16.769
>
  -100.432    17.213
   -99.788    16.769
>
   -99.819    16.914
   -99.861    17.081
>
   -99.819    16.914
   -99.861    17.081
>
   -99.651    17.021
   -99.861    17.081
>
   -99.651    17.021
   -99.861    17.081
>
   -99.887    16.874
   -99.861    17.081
>
   -99.887    16.874
   -99.861    17.081
>
  -100.267    17.048
   -99.861    17.081
>
  -100.267    17.048
   -99.861    17.081
>
  -100.432    17.213
   -99.861    17.081
>
  -100.432    17.213
   -99.861    17.081
>
   -99.131    16.736
   -99.861    17.081
>
   -99.131    16.736
   -99.861    17.081
>
   -99.620    17.926
   -99.861    17.081
>
   -99.620    17.926
   -99.861    17.081
>
   -99.131    16.736
   -99.266    16.498
>
   -99.651    17.021
   -99.266    16.498
>
   -99.819    16.914
   -99.884    17.146
>
   -99.819    16.914
   -99.884    17.146
>
   -99.651    17.021
   -99.884    17.146
>
   -99.651    17.021
   -99.884    17.146
>
  -100.267    17.048
   -99.884    17.146
>
  -100.267    17.048
   -99.884    17.146
>
  -100.432    17.213
   -99.884    17.146
>
  -100.432    17.213
   -99.884    17.146
>
   -99.131    16.736
   -99.884    17.146
>
   -99.131    16.736
   -99.884    17.146
>
   -99.620    17.926
   -99.884    17.146
>
   -99.819    16.914
   -99.886    17.206
>
   -99.819    16.914
   -99.886    17.206
>
   -99.651    17.021
   -99.886    17.206
>
   -99.651    17.021
   -99.886    17.206
>
  -100.267    17.048
   -99.886    17.206
>
  -100.267    17.048
   -99.886    17.206
>
  -100.432    17.213
   -99.886    17.206
>
  -100.432    17.213
   -99.886    17.206
>
   -99.620    17.926
   -99.886    17.206
>
   -99.620    17.926
   -99.886    17.206
>
   -99.131    16.736
   -99.886    17.206
>
   -99.131    16.736
   -99.886    17.206
>
   -99.887    16.874
  -100.051    16.814
>
   -99.887    16.874
  -100.051    16.814
>
   -99.651    17.021
  -100.051    16.814
>
   -99.651    17.021
  -100.051    16.814
>
   -99.131    16.736
  -100.051    16.814
>
   -99.131    16.736
  -100.051    16.814
>
   -99.887    16.874
  -100.012    16.897
>
   -99.651    17.021
  -100.012    16.897
>
   -99.651    17.021
  -100.012    16.897
>
  -100.432    17.213
  -100.012    16.897
>
   -99.131    16.736
  -100.012    16.897
>
   -99.131    16.736
  -100.012    16.897
>
  -100.432    17.213
  -100.495    17.267
>
  -100.267    17.048
  -100.495    17.267
>
  -100.267    17.048
  -100.495    17.267
>
   -99.887    16.874
  -100.495    17.267
>
   -99.651    17.021
  -100.495    17.267
>
  -101.263    17.535
  -100.495    17.267
>
  -101.263    17.535
  -100.495    17.267
>
  -101.465    17.607
  -100.495    17.267
>
  -100.267    17.048
  -100.162    16.761
>
  -100.267    17.048
  -100.162    16.761
>
  -100.432    17.213
  -100.162    16.761
>
  -100.432    17.213
  -100.162    16.761
>
   -99.651    17.021
  -100.162    16.761
>
   -99.131    16.736
  -100.162    16.761
>
   -99.131    16.736
  -100.162    16.761
>
   -99.651    17.021
   -99.611    17.024
>
   -99.651    17.021
   -99.611    17.024
>
  -100.432    17.213
   -99.611    17.024
>
  -100.432    17.213
   -99.611    17.024
>
   -99.620    17.926
   -99.611    17.024
>
   -98.634    17.234
   -99.611    17.024
>
   -98.634    17.234
   -99.611    17.024
>
   -99.131    16.736
   -98.916    16.534
>
   -99.131    16.736
   -98.916    16.534
>
   -98.127    16.392
   -98.916    16.534
>
   -99.131    16.736
   -99.137    16.974
>
   -99.131    16.736
   -99.137    16.974
>
   -99.651    17.021
   -99.137    16.974
>
   -99.651    17.021
   -99.137    16.974
>
   -98.566    17.563
   -99.137    16.974
>
   -98.566    17.563
   -99.137    16.974
>
   -98.560    17.798
   -99.137    16.974
>
   -98.560    17.798
   -99.137    16.974
>
   -99.651    17.021
   -99.518    17.133
>
   -99.651    17.021
   -99.518    17.133
>
   -99.131    16.736
   -99.518    17.133
>
   -99.131    16.736
   -99.518    17.133
>
  -100.267    17.048
   -99.518    17.133
>
  -100.267    17.048
   -99.518    17.133
>
   -99.620    17.926
   -99.518    17.133
>
   -99.620    17.926
   -99.518    17.133
>
  -100.432    17.213
   -99.518    17.133
>
  -100.432    17.213
   -99.518    17.133
>
  -100.267    17.048
  -100.045    17.149
>
  -100.267    17.048
  -100.045    17.149
>
   -99.651    17.021
  -100.045    17.149
>
   -99.651    17.021
  -100.045    17.149
>
  -100.432    17.213
  -100.045    17.149
>
  -100.432    17.213
  -100.045    17.149
>
   -99.620    17.926
  -100.045    17.149
>
   -99.620    17.926
  -100.045    17.149
>
   -99.651    17.021
   -99.945    17.277
>
   -99.651    17.021
   -99.945    17.277
>
  -100.267    17.048
   -99.945    17.277
>
  -100.267    17.048
   -99.945    17.277
>
  -100.432    17.213
   -99.945    17.277
>
  -100.432    17.213
   -99.945    17.277
>
   -99.620    17.926
   -99.945    17.277
>
   -99.620    17.926
   -99.945    17.277
>
   -99.819    16.914
   -99.881    16.829
>
   -99.819    16.914
   -99.881    16.829
>
   -99.651    17.021
   -99.881    16.829
>
  -100.267    17.048
   -99.881    16.829
>
  -100.432    17.213
   -99.881    16.829
>
  -100.432    17.213
   -99.881    16.829
>
   -99.131    16.736
   -99.881    16.829
>
   -99.131    16.736
   -99.881    16.829
>
   -99.651    17.021
   -99.909    16.863
>
   -99.651    17.021
   -99.909    16.863
>
  -100.432    17.213
   -99.909    16.863
>
   -99.651    17.021
   -99.905    16.930
>
   -99.651    17.021
   -99.905    16.930
>
  -100.432    17.213
   -99.905    16.930
>
  -100.432    17.213
   -99.905    16.930
>
   -99.819    16.914
   -99.715    16.930
>
   -99.819    16.914
   -99.715    16.930
>
   -99.651    17.021
   -99.715    16.930
>
   -99.651    17.021
   -99.715    16.930
>
  -100.267    17.048
   -99.715    16.930
>
  -100.267    17.048
   -99.715    16.930
>
   -99.131    16.736
   -99.715    16.930
>
   -99.131    16.736
   -99.715    16.930
>
  -100.432    17.213
   -99.715    16.930
>
  -100.432    17.213
   -99.715    16.930
>
   -99.620    17.926
   -99.715    16.930
>
   -99.620    17.926
   -99.715    16.930
>
   -99.651    17.021
   -99.787    17.062
>
   -99.651    17.021
   -99.787    17.062
>
   -99.819    16.914
   -99.787    17.062
>
  -100.267    17.048
   -99.787    17.062
>
  -100.267    17.048
   -99.787    17.062
>
  -100.432    17.213
   -99.787    17.062
>
  -100.432    17.213
   -99.787    17.062
>
   -99.131    16.736
   -99.787    17.062
>
   -99.131    16.736
   -99.787    17.062
>
   -99.620    17.926
   -99.787    17.062
>
   -99.620    17.926
   -99.787    17.062
>
   -99.131    16.736
   -98.923    16.964
>
   -99.131    16.736
   -98.923    16.964
>
   -98.634    17.234
   -98.923    16.964
>
   -98.634    17.234
   -98.923    16.964
>
   -98.566    17.563
   -98.923    16.964
>
   -98.566    17.563
   -98.923    16.964
>
   -99.651    17.021
   -98.923    16.964
>
   -99.651    17.021
   -98.923    16.964
>
   -99.819    16.914
   -98.923    16.964
>
   -98.560    17.798
   -98.923    16.964
>
   -98.560    17.798
   -98.923    16.964
>
   -98.127    16.392
   -98.923    16.964
>
   -98.634    17.234
   -98.761    16.944
>
   -98.634    17.234
   -98.761    16.944
>
   -99.131    16.736
   -98.761    16.944
>
   -99.131    16.736
   -98.761    16.944
>
   -98.566    17.563
   -98.761    16.944
>
   -98.566    17.563
   -98.761    16.944
>
   -98.127    16.392
   -98.761    16.944
>
   -99.651    17.021
   -98.761    16.944
>
   -99.651    17.021
   -98.761    16.944
>
   -98.560    17.798
   -98.761    16.944
>
   -98.560    17.798
   -98.761    16.944
>
   -97.768    17.253
   -98.761    16.944
>
   -97.768    17.253
   -98.761    16.944
>
   -99.651    17.021
   -99.818    16.763
>
   -99.651    17.021
   -99.818    16.763
>
  -100.267    17.048
   -99.818    16.763
>
  -100.267    17.048
   -99.818    16.763
>
   -99.131    16.736
   -99.818    16.763
>
  -100.432    17.213
   -99.818    16.763
>
  -100.432    17.213
   -99.818    16.763
>
   -99.651    17.021
   -99.751    16.773
>
   -99.651    17.021
   -99.751    16.773
>
   -99.131    16.736
   -99.751    16.773
>
   -99.131    16.736
   -99.751    16.773
>
  -100.267    17.048
   -99.751    16.773
>
  -100.267    17.048
   -99.751    16.773
>
  -100.432    17.213
   -99.751    16.773
>
   -99.651    17.021
   -99.920    17.197
>
   -99.651    17.021
   -99.920    17.197
>
  -100.267    17.048
   -99.920    17.197
>
  -100.267    17.048
   -99.920    17.197
>
  -100.432    17.213
   -99.920    17.197
>
  -100.432    17.213
   -99.920    17.197
>
   -99.620    17.926
   -99.920    17.197
>
   -99.131    16.736
   -99.920    17.197
>
   -99.131    16.736
   -99.920    17.197
>
   -98.634    17.234
   -98.797    16.991
>
   -99.131    16.736
   -98.797    16.991
>
   -99.131    16.736
   -98.797    16.991
>
   -98.566    17.563
   -98.797    16.991
>
   -98.566    17.563
   -98.797    16.991
>
   -98.127    16.392
   -98.797    16.991
>
   -98.127    16.392
   -98.797    16.991
>
   -98.566    17.563
   -98.917    17.173
>
   -98.566    17.563
   -98.917    17.173
>
   -99.131    16.736
   -98.917    17.173
>
   -99.131    16.736
   -98.917    17.173
>
   -99.651    17.021
   -98.917    17.173
>
   -99.651    17.021
   -98.917    17.173
>
  -100.267    17.048
  -100.050    17.110
>
  -100.267    17.048
  -100.050    17.110
>
   -99.819    16.914
  -100.050    17.110
>
   -99.819    16.914
  -100.050    17.110
>
  -100.432    17.213
  -100.050    17.110
>
   -99.651    17.021
  -100.050    17.110
>
   -99.620    17.926
  -100.050    17.110
>
   -99.620    17.926
  -100.050    17.110
>
   -99.131    16.736
  -100.050    17.110
>
  -100.267    17.048
  -100.075    16.897
>
  -100.267    17.048
  -100.075    16.897
>
   -99.651    17.021
  -100.075    16.897
>
   -99.651    17.021
  -100.075    16.897
>
  -100.432    17.213
  -100.075    16.897
>
  -100.432    17.213
  -100.075    16.897
>
   -99.131    16.736
  -100.075    16.897
>
   -99.131    16.736
  -100.075    16.897
>
   -99.651    17.021
   -99.694    17.276
>
   -99.651    17.021
   -99.694    17.276
>
  -100.267    17.048
   -99.694    17.276
>
  -100.267    17.048
   -99.694    17.276
>
   -99.620    17.926
   -99.694    17.276
>
   -99.620    17.926
   -99.694    17.276
>
  -100.432    17.213
   -99.694    17.276
>
  -100.432    17.213
   -99.694    17.276
>
   -99.131    16.736
   -99.694    17.276
>
   -99.131    16.736
   -99.694    17.276
>
   -99.651    17.021
   -99.919    17.121
>
   -99.651    17.021
   -99.919    17.121
>
  -100.267    17.048
   -99.919    17.121
>
  -100.267    17.048
   -99.919    17.121
>
  -100.432    17.213
   -99.919    17.121
>
  -100.432    17.213
   -99.919    17.121
>
   -99.620    17.926
   -99.919    17.121
>
   -99.620    17.926
   -99.919    17.121
>
   -99.131    16.736
   -99.919    17.121
>
   -99.131    16.736
   -99.919    17.121
>
  -100.267    17.048
  -100.062    16.889
>
  -100.267    17.048
  -100.062    16.889
>
   -99.651    17.021
  -100.062    16.889
>
   -99.651    17.021
  -100.062    16.889
>
  -100.432    17.213
  -100.062    16.889
>
   -99.131    16.736
  -100.062    16.889
>
   -99.131    16.736
  -100.062    16.889
>
   -99.651    17.021
   -99.522    16.713
>
   -99.651    17.021
   -99.522    16.713
>
  -100.267    17.048
   -99.522    16.713
>
  -100.267    17.048
   -99.522    16.713
>
  -100.267    17.048
  -100.218    17.254
>
  -100.267    17.048
  -100.218    17.254
>
  -100.432    17.213
  -100.218    17.254
>
  -100.432    17.213
  -100.218    17.254
>
   -99.651    17.021
  -100.218    17.254
>
   -99.651    17.021
  -100.218    17.254
>
   -99.620    17.926
  -100.218    17.254
>
   -99.620    17.926
  -100.218    17.254
>
  -100.267    17.048
   -99.966    17.078
>
  -100.267    17.048
   -99.966    17.078
>
   -99.651    17.021
   -99.966    17.078
>
   -99.651    17.021
   -99.966    17.078
>
  -100.432    17.213
   -99.966    17.078
>
  -100.432    17.213
   -99.966    17.078
>
   -99.131    16.736
   -99.966    17.078
>
   -99.131    16.736
   -99.966    17.078
>
  -100.267    17.048
  -100.115    17.173
>
  -100.267    17.048
  -100.115    17.173
>
  -100.432    17.213
  -100.115    17.173
>
  -100.432    17.213
  -100.115    17.173
>
   -99.651    17.021
  -100.115    17.173
>
   -99.651    17.021
  -100.115    17.173
>
   -99.620    17.926
  -100.115    17.173
>
   -99.620    17.926
  -100.115    17.173
>
  -100.432    17.213
  -100.278    17.230
>
  -100.432    17.213
  -100.278    17.230
>
  -100.267    17.048
  -100.278    17.230
>
  -100.267    17.048
  -100.278    17.230
>
   -99.651    17.021
  -100.278    17.230
>
   -99.651    17.021
  -100.278    17.230
>
   -99.620    17.926
  -100.278    17.230
>
   -99.620    17.926
  -100.278    17.230
>
  -100.267    17.048
  -100.109    17.219
>
  -100.267    17.048
  -100.109    17.219
>
  -100.432    17.213
  -100.109    17.219
>
  -100.432    17.213
  -100.109    17.219
>
   -99.651    17.021
  -100.109    17.219
>
   -99.651    17.021
  -100.109    17.219
>
   -99.620    17.926
  -100.109    17.219
>
   -99.620    17.926
  -100.109    17.219
>
   -99.131    16.736
   -99.470    16.570
>
   -99.131    16.736
   -99.470    16.570
>
   -99.651    17.021
   -99.470    16.570
>
  -100.267    17.048
   -99.470    16.570
>
   -99.651    17.021
   -99.711    17.248
>
   -99.651    17.021
   -99.711    17.248
>
  -100.267    17.048
   -99.711    17.248
>
  -100.267    17.048
   -99.711    17.248
>
  -100.432    17.213
   -99.711    17.248
>
  -100.432    17.213
   -99.711    17.248
>
   -99.620    17.926
   -99.711    17.248
>
   -99.620    17.926
   -99.711    17.248
>
   -99.131    16.736
   -99.711    17.248
>
   -99.131    16.736
   -99.711    17.248
>
  -100.267    17.048
   -99.953    17.152
>
  -100.267    17.048
   -99.953    17.152
>
   -99.651    17.021
   -99.953    17.152
>
   -99.651    17.021
   -99.953    17.152
>
  -100.432    17.213
   -99.953    17.152
>
  -100.432    17.213
   -99.953    17.152
>
   -99.620    17.926
   -99.953    17.152
>
   -99.620    17.926
   -99.953    17.152
>
   -99.131    16.736
   -99.953    17.152
>
   -99.131    16.736
   -99.953    17.152
>
   -99.651    17.021
   -99.910    17.204
>
   -99.651    17.021
   -99.910    17.204
>
  -100.267    17.048
   -99.910    17.204
>
  -100.267    17.048
   -99.910    17.204
>
  -100.432    17.213
   -99.910    17.204
>
  -100.432    17.213
   -99.910    17.204
>
   -99.620    17.926
   -99.910    17.204
>
   -99.620    17.926
   -99.910    17.204
>
   -99.131    16.736
   -99.910    17.204
>
   -99.131    16.736
   -99.910    17.204
>
   -99.651    17.021
  -100.061    16.870
>
  -100.432    17.213
  -100.061    16.870
>
  -100.432    17.213
  -100.061    16.870
>
   -99.131    16.736
  -100.061    16.870
>
   -99.131    16.736
  -100.061    16.870
>
   -99.131    16.736
   -99.412    16.491
>
   -99.651    17.021
   -99.412    16.491
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
  -100.267    17.048     0.300
   -99.858    16.869     0.300
  -101.465    17.607     0.300
   -99.620    17.926     0.300
   -99.887    16.874     0.300
   -98.127    16.392     0.300
   -98.566    17.563     0.300
   -99.131    16.736     0.300
   -99.651    17.021     0.300
   -98.634    17.234     0.300
   -98.560    17.798     0.300
   -97.768    17.253     0.300
   -99.819    16.914     0.300
  -100.432    17.213     0.300
  -101.263    17.535     0.300
  -100.347    18.281     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
   -99.365    16.827     0.200
>
  -100.092    16.981     0.200
>
  -100.507    17.255     0.200
>
  -100.320    17.209     0.200
>
  -100.302    17.203     0.200
>
  -100.113    16.966     0.200
>
  -100.300    16.896     0.200
>
   -99.570    16.909     0.200
>
   -99.659    17.094     0.200
>
   -99.617    16.781     0.200
>
   -98.801    16.723     0.200
>
   -99.603    16.909     0.200
>
  -100.097    17.009     0.200
>
   -99.340    16.591     0.200
>
   -99.517    16.819     0.200
>
   -99.649    16.796     0.200
>
  -100.101    16.810     0.200
>
   -99.871    17.167     0.200
>
   -99.785    16.742     0.200
>
   -99.730    17.064     0.200
>
   -98.928    16.939     0.200
>
   -98.750    16.951     0.200
>
   -99.566    17.082     0.200
>
  -100.021    17.133     0.200
>
   -99.437    16.709     0.200
>
  -100.219    17.213     0.200
>
   -99.771    17.009     0.200
>
   -99.715    16.779     0.200
>
   -99.032    16.446     0.200
>
  -100.447    17.323     0.200
>
   -99.655    17.151     0.200
>
   -99.468    16.659     0.200
>
  -100.075    17.188     0.200
>
   -99.677    17.162     0.200
>
  -100.423    16.877     0.200
>
   -99.881    16.892     0.200
>
   -99.682    17.058     0.200
>
   -99.024    16.932     0.200
>
   -99.610    17.167     0.200
>
  -100.417    17.302     0.200
>
   -99.042    17.100     0.200
>
  -100.026    17.165     0.200
>
   -99.926    17.099     0.200
>
   -99.788    16.769     0.200
>
   -99.861    17.081     0.200
>
   -99.266    16.498     0.200
>
   -99.884    17.146     0.200
>
   -99.886    17.206     0.200
>
  -100.051    16.814     0.200
>
  -100.012    16.897     0.200
>
  -100.495    17.267     0.200
>
  -100.162    16.761     0.200
>
   -99.611    17.024     0.200
>
   -98.916    16.534     0.200
>
   -99.137    16.974     0.200
>
   -99.518    17.133     0.200
>
  -100.045    17.149     0.200
>
   -99.945    17.277     0.200
>
   -99.881    16.829     0.200
>
   -99.909    16.863     0.200
>
   -99.905    16.930     0.200
>
   -99.715    16.930     0.200
>
   -99.787    17.062     0.200
>
   -98.923    16.964     0.200
>
   -98.761    16.944     0.200
>
   -99.818    16.763     0.200
>
   -99.751    16.773     0.200
>
   -99.920    17.197     0.200
>
   -98.797    16.991     0.200
>
   -98.917    17.173     0.200
>
  -100.050    17.110     0.200
>
  -100.075    16.897     0.200
>
   -99.694    17.276     0.200
>
   -99.919    17.121     0.200
>
  -100.062    16.889     0.200
>
   -99.522    16.713     0.200
>
  -100.218    17.254     0.200
>
   -99.966    17.078     0.200
>
  -100.115    17.173     0.200
>
  -100.278    17.230     0.200
>
  -100.109    17.219     0.200
>
   -99.470    16.570     0.200
>
   -99.711    17.248     0.200
>
   -99.953    17.152     0.200
>
   -99.910    17.204     0.200
>
  -100.061    16.870     0.200
>
   -99.412    16.491     0.200
>
   -99.462    16.738     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
   -99.747    16.980     0.000   222.000   222.000
   -99.747    16.980     0.000   444.000   444.000
EOF
gmt end
