#!/bin/bash
gmt begin acapulco7.51_base pdf,ps
proj=-JM16.0c+
reg=-R-100.6/-98.6/16.3/17.4
gmt basemap $proj $reg -Bxa0.5f0.1 -Bya0.5f0.1 -BWeSn+t'Base Map acapulco7.51'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
   -99.365    16.827 1
  -100.092    16.981 2
  -100.507    17.255 3
  -100.320    17.209 4
  -100.302    17.203 5
  -100.113    16.966 6
  -100.300    16.896 7
   -99.570    16.909 8
   -99.659    17.094 9
   -99.617    16.781 10
   -98.801    16.723 11
   -99.603    16.909 12
  -100.097    17.009 13
   -99.340    16.591 14
   -99.517    16.819 15
   -99.649    16.796 16
  -100.101    16.810 17
   -99.871    17.167 18
   -99.785    16.742 19
   -99.730    17.064 20
   -98.928    16.939 21
   -98.750    16.951 22
   -99.566    17.082 23
  -100.021    17.133 24
   -99.437    16.709 25
  -100.219    17.213 26
   -99.771    17.009 27
   -99.715    16.779 28
   -99.032    16.446 29
  -100.447    17.323 30
   -99.655    17.151 31
   -99.468    16.659 32
  -100.075    17.188 33
   -99.677    17.162 34
  -100.423    16.877 35
   -99.881    16.892 36
   -99.682    17.058 37
   -99.024    16.932 38
   -99.610    17.167 39
  -100.417    17.302 40
   -99.042    17.100 41
  -100.026    17.165 42
   -99.926    17.099 43
   -99.788    16.769 44
   -99.861    17.081 45
   -99.266    16.498 46
   -99.884    17.146 47
   -99.886    17.206 48
  -100.051    16.814 49
  -100.012    16.897 50
  -100.495    17.267 51
  -100.162    16.761 52
   -99.611    17.024 53
   -98.916    16.534 54
   -99.137    16.974 55
   -99.518    17.133 56
  -100.045    17.149 57
   -99.945    17.277 58
   -99.881    16.829 59
   -99.909    16.863 60
   -99.905    16.930 61
   -99.715    16.930 62
   -99.787    17.062 63
   -98.923    16.964 64
   -98.761    16.944 65
   -99.818    16.763 66
   -99.751    16.773 67
   -99.920    17.197 68
   -98.797    16.991 69
   -98.917    17.173 70
  -100.050    17.110 71
  -100.075    16.897 72
   -99.694    17.276 73
   -99.919    17.121 74
  -100.062    16.889 75
   -99.522    16.713 76
  -100.218    17.254 77
   -99.966    17.078 78
  -100.115    17.173 79
  -100.278    17.230 80
  -100.109    17.219 81
   -99.470    16.570 82
   -99.711    17.248 83
   -99.953    17.152 84
   -99.910    17.204 85
  -100.061    16.870 86
   -99.412    16.491 87
   -99.462    16.738 88
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
   -99.256    16.864
   -99.365    16.827
>
  -100.086    17.043
  -100.092    16.981
>
  -100.458    17.257
  -100.507    17.255
>
  -100.308    17.230
  -100.320    17.209
>
  -100.265    17.196
  -100.302    17.203
>
  -100.097    17.109
  -100.113    16.966
>
  -100.306    16.893
  -100.300    16.896
>
   -99.568    16.951
   -99.570    16.909
>
   -99.676    17.084
   -99.659    17.094
>
   -99.589    16.965
   -99.617    16.781
>
   -98.802    16.701
   -98.801    16.723
>
   -99.557    16.940
   -99.603    16.909
>
  -100.103    17.080
  -100.097    17.009
>
   -99.373    16.527
   -99.340    16.591
>
   -99.519    16.857
   -99.517    16.819
>
   -99.606    16.872
   -99.649    16.796
>
  -100.000    16.938
  -100.101    16.810
>
   -99.860    17.098
   -99.871    17.167
>
   -99.635    16.848
   -99.785    16.742
>
   -99.701    17.070
   -99.730    17.064
>
   -98.922    16.918
   -98.928    16.939
>
   -98.738    16.947
   -98.750    16.951
>
   -99.585    17.052
   -99.566    17.082
>
   -99.934    17.185
  -100.021    17.133
>
   -99.426    16.762
   -99.437    16.709
>
  -100.237    17.209
  -100.219    17.213
>
   -99.710    17.073
   -99.771    17.009
>
   -99.740    16.718
   -99.715    16.779
>
   -99.003    16.578
   -99.032    16.446
>
  -100.481    17.288
  -100.447    17.323
>
   -99.688    17.155
   -99.655    17.151
>
   -99.498    16.730
   -99.468    16.659
>
  -100.095    17.163
  -100.075    17.188
>
   -99.690    17.118
   -99.677    17.162
>
  -100.433    16.911
  -100.423    16.877
>
   -99.841    16.859
   -99.881    16.892
>
   -99.645    17.030
   -99.682    17.058
>
   -99.034    17.001
   -99.024    16.932
>
   -99.558    17.271
   -99.610    17.167
>
  -100.434    17.295
  -100.417    17.302
>
   -99.025    17.102
   -99.042    17.100
>
  -100.013    17.178
  -100.026    17.165
>
   -99.948    17.089
   -99.926    17.099
>
   -99.823    16.716
   -99.788    16.769
>
   -99.854    17.082
   -99.861    17.081
>
   -99.311    16.408
   -99.266    16.498
>
   -99.920    17.081
   -99.884    17.146
>
   -99.891    17.168
   -99.886    17.206
>
  -100.040    16.837
  -100.051    16.814
>
  -100.031    16.917
  -100.012    16.897
>
  -100.418    17.235
  -100.495    17.267
>
  -100.158    16.830
  -100.162    16.761
>
   -99.628    17.080
   -99.611    17.024
>
   -98.954    16.483
   -98.916    16.534
>
   -99.136    16.996
   -99.137    16.974
>
   -99.525    17.098
   -99.518    17.133
>
  -100.021    17.121
  -100.045    17.149
>
   -99.946    17.279
   -99.945    17.277
>
   -99.839    16.872
   -99.881    16.829
>
   -99.902    16.846
   -99.909    16.863
>
   -99.894    16.894
   -99.905    16.930
>
   -99.718    16.894
   -99.715    16.930
>
   -99.799    17.081
   -99.787    17.062
>
   -98.915    16.959
   -98.923    16.964
>
   -98.760    16.939
   -98.761    16.944
>
   -99.798    16.781
   -99.818    16.763
>
   -99.719    16.795
   -99.751    16.773
>
   -99.909    17.237
   -99.920    17.197
>
   -98.809    16.986
   -98.797    16.991
>
   -98.929    17.274
   -98.917    17.173
>
  -100.051    17.094
  -100.050    17.110
>
   -99.987    16.915
  -100.075    16.897
>
   -99.698    17.255
   -99.694    17.276
>
   -99.893    17.156
   -99.919    17.121
>
  -100.035    16.873
  -100.062    16.889
>
   -99.536    16.712
   -99.522    16.713
>
  -100.269    17.189
  -100.218    17.254
>
   -99.961    17.154
   -99.966    17.078
>
  -100.093    17.180
  -100.115    17.173
>
  -100.302    17.183
  -100.278    17.230
>
  -100.120    17.164
  -100.109    17.219
>
   -99.445    16.669
   -99.470    16.570
>
   -99.720    17.224
   -99.711    17.248
>
   -99.961    17.116
   -99.953    17.152
>
   -99.910    17.189
   -99.910    17.204
>
   -99.880    17.090
  -100.061    16.870
>
   -99.260    16.632
   -99.412    16.491
>
   -99.303    16.902
   -99.462    16.738
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
   -99.366    16.826
   -99.365    16.827
>
  -100.092    16.981
  -100.092    16.981
>
  -100.506    17.256
  -100.507    17.255
>
  -100.319    17.208
  -100.320    17.209
>
  -100.301    17.202
  -100.302    17.203
>
  -100.113    16.964
  -100.113    16.966
>
  -100.299    16.898
  -100.300    16.896
>
   -99.570    16.909
   -99.570    16.909
>
   -99.659    17.097
   -99.659    17.094
>
   -99.617    16.781
   -99.617    16.781
>
   -98.802    16.722
   -98.801    16.723
>
   -99.604    16.909
   -99.603    16.909
>
  -100.097    17.008
  -100.097    17.009
>
   -99.340    16.581
   -99.340    16.591
>
   -99.516    16.820
   -99.517    16.819
>
   -99.649    16.796
   -99.649    16.796
>
  -100.101    16.811
  -100.101    16.810
>
   -99.876    17.170
   -99.871    17.167
>
   -99.783    16.741
   -99.785    16.742
>
   -99.728    17.060
   -99.730    17.064
>
   -98.929    16.941
   -98.928    16.939
>
   -98.750    16.950
   -98.750    16.951
>
   -99.566    17.083
   -99.566    17.082
>
  -100.021    17.132
  -100.021    17.133
>
   -99.436    16.708
   -99.437    16.709
>
  -100.219    17.213
  -100.219    17.213
>
   -99.771    17.008
   -99.771    17.009
>
   -99.714    16.778
   -99.715    16.779
>
   -99.032    16.444
   -99.032    16.446
>
  -100.447    17.325
  -100.447    17.323
>
   -99.658    17.156
   -99.655    17.151
>
   -99.468    16.656
   -99.468    16.659
>
  -100.074    17.189
  -100.075    17.188
>
   -99.677    17.162
   -99.677    17.162
>
  -100.421    16.876
  -100.423    16.877
>
   -99.881    16.892
   -99.881    16.892
>
   -99.681    17.060
   -99.682    17.058
>
   -99.022    16.931
   -99.024    16.932
>
   -99.610    17.167
   -99.610    17.167
>
  -100.417    17.302
  -100.417    17.302
>
   -99.041    17.098
   -99.042    17.100
>
  -100.024    17.165
  -100.026    17.165
>
   -99.927    17.099
   -99.926    17.099
>
   -99.788    16.770
   -99.788    16.769
>
   -99.861    17.080
   -99.861    17.081
>
   -99.267    16.499
   -99.266    16.498
>
   -99.885    17.150
   -99.884    17.146
>
   -99.887    17.206
   -99.886    17.206
>
  -100.051    16.814
  -100.051    16.814
>
  -100.013    16.898
  -100.012    16.897
>
  -100.496    17.266
  -100.495    17.267
>
  -100.164    16.766
  -100.162    16.761
>
   -99.612    17.027
   -99.611    17.024
>
   -98.914    16.534
   -98.916    16.534
>
   -99.136    16.974
   -99.137    16.974
>
   -99.518    17.135
   -99.518    17.133
>
  -100.046    17.149
  -100.045    17.149
>
   -99.945    17.277
   -99.945    17.277
>
   -99.882    16.828
   -99.881    16.829
>
   -99.910    16.863
   -99.909    16.863
>
   -99.905    16.928
   -99.905    16.930
>
   -99.715    16.928
   -99.715    16.930
>
   -99.789    17.060
   -99.787    17.062
>
   -98.923    16.965
   -98.923    16.964
>
   -98.761    16.945
   -98.761    16.944
>
   -99.818    16.763
   -99.818    16.763
>
   -99.748    16.772
   -99.751    16.773
>
   -99.921    17.198
   -99.920    17.197
>
   -98.796    16.992
   -98.797    16.991
>
   -98.916    17.173
   -98.917    17.173
>
  -100.051    17.110
  -100.050    17.110
>
  -100.074    16.900
  -100.075    16.897
>
   -99.695    17.278
   -99.694    17.276
>
   -99.919    17.120
   -99.919    17.121
>
  -100.064    16.883
  -100.062    16.889
>
   -99.522    16.711
   -99.522    16.713
>
  -100.219    17.255
  -100.218    17.254
>
   -99.966    17.079
   -99.966    17.078
>
  -100.115    17.173
  -100.115    17.173
>
  -100.278    17.230
  -100.278    17.230
>
  -100.109    17.216
  -100.109    17.219
>
   -99.470    16.571
   -99.470    16.570
>
   -99.711    17.249
   -99.711    17.248
>
   -99.953    17.155
   -99.953    17.152
>
   -99.910    17.206
   -99.910    17.204
>
  -100.061    16.869
  -100.061    16.870
>
   -99.413    16.490
   -99.412    16.491
>
   -99.463    16.737
   -99.462    16.738
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
   -99.365    16.827    26.060     0.597     2.666
  -100.092    16.981   -65.891     2.140     3.705
  -100.507    17.255   -58.539     2.162     3.962
  -100.320    17.209   -56.337     0.947     1.578
  -100.302    17.203   -61.398     1.112     2.011
  -100.113    16.966   -65.548     1.266     2.001
  -100.300    16.896   -69.843     1.674     2.612
   -99.570    16.909   -44.824     0.993     1.590
   -99.659    17.094   -58.098     2.651     2.830
   -99.617    16.781    89.664     1.243     1.722
   -98.801    16.723   -79.635     1.634     1.930
   -99.603    16.909    85.837     1.661     2.442
  -100.097    17.009   -71.210     2.063     2.731
   -99.340    16.591    88.453     1.943     3.934
   -99.517    16.819   -72.616     1.114     1.584
   -99.649    16.796   -86.121     1.223     2.112
  -100.101    16.810   -86.059     1.718     3.095
   -99.871    17.167   -46.261     2.603     2.980
   -99.785    16.742   -70.778     1.838     3.572
   -99.730    17.064   -79.688     2.800     4.142
   -98.928    16.939   -68.571     1.172     1.575
   -98.750    16.951    75.168     2.045     3.481
   -99.566    17.082    79.438     1.501     2.298
  -100.021    17.133   -69.733     2.143     3.075
   -99.437    16.709   -60.750     1.525     2.503
  -100.219    17.213   -57.827     1.665     2.216
   -99.771    17.009   -80.495     1.844     2.953
   -99.715    16.779   -82.775     1.521     2.350
   -99.032    16.446   -55.262     2.157     2.826
  -100.447    17.323   -68.493     1.387     2.668
   -99.655    17.151    80.634     2.196     3.371
   -99.468    16.659    88.788     2.488     4.142
  -100.075    17.188   -75.037     1.324     2.057
   -99.677    17.162    59.540     1.266     2.056
  -100.423    16.877   -62.908     0.919     1.344
   -99.881    16.892   -74.242     1.794     3.172
   -99.682    17.058   -86.600     1.366     2.356
   -99.024    16.932    73.893     2.529     4.576
   -99.610    17.167    78.612     1.731     2.430
  -100.417    17.302   -41.092     3.904     4.412
   -99.042    17.100    73.770     2.657     3.484
  -100.026    17.165    -1.999     1.418     1.764
   -99.926    17.099   -61.888     1.651     2.139
   -99.788    16.769   -88.771     1.398     2.041
   -99.861    17.081   -85.238     2.175     2.558
   -99.266    16.498    87.037     2.205     3.583
   -99.884    17.146    81.236     2.265     2.886
   -99.886    17.206    54.880     1.324     1.575
  -100.051    16.814   -73.054     1.280     2.667
  -100.012    16.897   -88.622     1.665     2.316
  -100.495    17.267   -59.239     1.393     2.207
  -100.162    16.761    72.773     1.834     2.419
   -99.611    17.024    86.798     2.455     3.905
   -98.916    16.534   -36.320     1.317     2.207
   -99.137    16.974    89.592     1.787     2.593
   -99.518    17.133   -88.574     2.340     3.441
  -100.045    17.149   -85.189     1.840     2.577
   -99.945    17.277    75.465     2.462     3.926
   -99.881    16.829   -44.995     1.028     1.627
   -99.909    16.863   -53.282     1.882     2.691
   -99.905    16.930   -71.313     2.243     2.922
   -99.715    16.930   -85.779     1.960     3.758
   -99.787    17.062   -85.055     1.967     2.649
   -98.923    16.964    75.872     2.218     4.107
   -98.761    16.944    86.170     1.942     3.024
   -99.818    16.763   -78.215     2.468     3.204
   -99.751    16.773   -31.695     1.559     2.049
   -99.920    17.197    86.296     2.451     3.808
   -98.797    16.991    68.741     2.863     3.462
   -98.917    17.173    61.208     2.120     3.440
  -100.050    17.110    88.005     1.800     2.225
  -100.075    16.897   -69.332     1.991     3.609
   -99.694    17.276    84.340     2.380     3.663
   -99.919    17.121   -80.621     2.045     2.464
  -100.062    16.889   -70.255     2.290     3.006
   -99.522    16.713   -81.124     1.892     2.443
  -100.218    17.254     7.617     1.926     2.310
   -99.966    17.078    86.790     2.139     4.034
  -100.115    17.173   -63.243     1.352     1.450
  -100.278    17.230   -61.079     2.544     2.841
  -100.109    17.219    64.963     2.195     2.261
   -99.470    16.570   -40.782     1.591     2.255
   -99.711    17.248    86.546     2.194     3.365
   -99.953    17.152    89.529     2.424     3.823
   -99.910    17.204   -87.954     2.159     2.670
  -100.061    16.870   -48.561     1.738     2.382
   -99.412    16.491   -39.489     1.853     2.555
   -99.462    16.738   -25.142     2.031     3.496
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
   -99.365    16.827     0.200
  -100.320    17.209     0.200
   -99.517    16.819     0.200
   -99.881    16.829     0.300
   -99.462    16.738     0.200
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -100.551    16.398   -69.972     0.917     1.783
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -100.528    16.398   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -100.551    16.398     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -100.551    16.398     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -100.551    16.353   5 km
EOF
gmt end
